<?php

namespace Genealogy\App\Controller;

use Genealogy\App\Model\TimelineModel;

class TimelineController
{
    private $config;

    public function __construct($config)
    {
        $this->config = $config;
    }

    public function getTimeline($id): array
    {
        $TimelineModel = new TimelineModel($this->config);

        $personDb = $this->config['db_functions']->get_person($id);
        $person_data = $TimelineModel->getPersonData($personDb);
        $get_timeline_persons = $TimelineModel->getTimelinePersons($personDb);

        //$data = array(
        //    "title" => __('Timeline')
        //);

        // *** Add array $person_data:
        //$data = array_merge($data, $person_data);
        $data = $person_data;

        if ($get_timeline_persons) {
            $data = array_merge($data, $get_timeline_persons);
        }

        return $data;
    }
}
